/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSGenericNetherConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class CityNetherStructure<C extends RSGenericNetherConfig>
extends GenericJigsawStructure<C> {
    public CityNetherStructure(Codec<C> codec) {
        super(codec, CityNetherStructure::isCityNetherFeatureChunk, CityNetherStructure::generateCityNetherPieces);
    }

    protected static <CC extends RSGenericNetherConfig> boolean isCityNetherFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        ChunkPos chunkPos = context.f_197355_();
        if (GenericJigsawStructure.isGenericFeatureChunk(context)) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int curChunkX = chunkPos.f_45578_ - 1; curChunkX <= chunkPos.f_45578_ + 1; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - 1; curChunkZ <= chunkPos.f_45579_ + 1; ++curChunkZ) {
                    mutable.m_122178_(curChunkX << 4, context.f_197352_().m_6337_() + 10, curChunkZ << 4);
                    NoiseColumn blockView = context.f_197352_().m_141914_(mutable.m_123341_(), mutable.m_123343_(), context.f_197357_());
                    int minValidSpace = 65;
                    int maxHeight = Math.min(GeneralUtils.getMaxTerrainLimit(context.f_197352_()), context.f_197352_().m_6337_() + minValidSpace);
                    while (mutable.m_123342_() < maxHeight) {
                        BlockState state = blockView.m_183556_(mutable.m_123342_());
                        if (!state.m_60795_()) {
                            return false;
                        }
                        mutable.m_122173_(Direction.UP);
                    }
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static <CC extends RSGenericNetherConfig> Optional<PieceGenerator<CC>> generateCityNetherPieces(PieceGeneratorSupplier.Context<CC> context) {
        RSGenericNetherConfig config = (RSGenericNetherConfig)context.f_197356_();
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), context.f_197352_().m_6337_(), context.f_197355_().m_45605_());
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> ((PoolElementStructurePiece)pieces.get(0)).m_6324_(0, config.centerYOffset, 0));
    }
}

